<?php

namespace PostAffiliatePro;

use Enlight_Controller_Request_Request;
use Enlight_View_Default;
use Shopware\Components\Plugin;
use Shopware\Components\Plugin\Context\ActivateContext;
use Shopware\Components\Plugin\Context\InstallContext;
use Shopware\Components\Plugin\Context\UninstallContext;

class PostAffiliatePro extends Plugin {

    public function activate(ActivateContext $context) {
        $context->scheduleClearCache(InstallContext::CACHE_LIST_ALL);
    }

    public function uninstall(UninstallContext $context) {
        if ($context->keepUserData()) {
            return;
        }
        $context->scheduleClearCache(InstallContext::CACHE_LIST_ALL);
    }

    public static function getSubscribedEvents() {
        $event1 = 'onPostDispatch';
        return [
                'Enlight_Controller_Action_PostDispatchSecure_Frontend' => $event1,
                'Enlight_Controller_Action_PostDispatchSecure_Widgets' => $event1
            ];
    }

    public function onPostDispatch(\Enlight_Event_EventArgs $args) {
        $view = $args->getSubject()->View();
        $view->addTemplateDir($this->getPath() . '/Resources/views');

        if ($args->getSubject()->Request()->isXmlHttpRequest()) {
            return;
        }

        $config = $this->getPluginConfig();

        if (empty($config['pap_url'])) {
            return;
        }
        $this->prepareTrackingCode($view, $config);
    }

    private function getPluginConfig() {
        $container = $this->container;
        $configReader = $container->get('shopware.plugin.cached_config_reader');
        $config = $configReader->getByPluginName('PostAffiliatePro', $container->get('shop'));

        if (!empty($config['pap_url'])) {
            // needed format is sub.domain.com/installation_dir/
            $config['pap_url'] = str_replace('https://', '', $config['pap_url']);
            $config['pap_url'] = str_replace('http://', '', $config['pap_url']);
            $config['pap_url'] = rtrim($config['pap_url'], '/') . '/';
        }
        if (empty($config['tracking_style'])) {
            $config['tracking_style'] = 'id';
        }
        if (empty($config['account_id'])) {
            $config['account_id'] = 'default1';
        }
        return $config;
    }

    private function prepareTrackingCode(Enlight_View_Default $view, array $config) {
        $view->assign('InstallURL', $config['pap_url']);
        $view->assign('AccountID', $config['account_id']);
        $view->assign('TrackingStyle', $config['tracking_style']);
        $view->assign('TrackCoupon', $config['track_coupon']);
    }
}