<?php
declare(strict_types=1);

namespace Qu\Postaffiliatepro\Service;

use Exception;

class HttpService {

    /**
     * @param string       $url
     * @param string       $method
     * @param string[]     $header
     * @param string|array $data
     *
     * @throws Exception
     */
    public function call($url, $data = null, $method = 'POST', array $header = []) {
        if (!\function_exists('curl_init')) {
            throw new Exception('curl not loaded');
        }

        $curl = curl_init();
        curl_setopt($curl, \CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, \CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, \CURLOPT_USERAGENT, 'Shopware PAP plugin');
        curl_setopt($curl, \CURLOPT_URL, $url);
        curl_setopt($curl, \CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($curl, \CURLOPT_POSTFIELDS, $data);

        $response = curl_exec($curl);

        $errcode = curl_errno($curl);
        $errmsg = curl_error($curl);

        curl_close($curl);
        if ($response === false) {
            throw new Exception($errmsg, $errcode);
        }

        return $response;
    }
}