<?php

namespace Qu\Postaffiliatepro\Service;

use Exception;
use Monolog\Logger;
use Shopware\Core\Checkout\Order\OrderEntity;
use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;

class OrderService {

    /** @var EntityRepository */
    protected $orderRepository;

    /** @var LoggerInterface */
    protected $logger;

    public function __construct(
        EntityRepository $orderRepository,
        Logger $logger
    )
    {
        $this->orderRepository = $orderRepository;
        $this->logger = $logger;
    }

    public function getOrderRepository(): EntityRepository {
        return $this->orderRepository;
    }

    public function getOrder(string $orderId, Context $context): ?OrderEntity {
        $order = null;

        try {
            $criteria = new Criteria([$orderId]);
            $criteria->addAssociation('order');

            /** @var OrderEntity $order */
            $order = $this->orderRepository->search($criteria, $context)->first();
        } catch (Exception $e) {
            $this->logger->addRecord(Logger::ERROR, 'Post Affiliate Pro: '.$e->getMessage());
        }

        return $order;
    }

    public function debug(string $message): void {
        $this->logger->addRecord(Logger::DEBUG, 'Post Affiliate Pro: '.$message);
    }
}
