<?php
declare(strict_types=1);

namespace Qu\Postaffiliatepro\Service;

use Qu\Postaffiliatepro\Settings\ConfigurationStruct;
use Shopware\Core\Framework\Context;
use Shopware\Core\System\SystemConfig\SystemConfigService;

class SettingsService {
    public const SYSTEM_CONFIG_DOMAIN = 'QuPostaffiliatepro.config.';

    /** @var SystemConfigService */
    protected $systemConfigService;

    public function __construct(SystemConfigService $systemConfigService) {
        $this->systemConfigService = $systemConfigService;
    }

    /**
     * @param string|null  $salesChannelId
     * @param Context|null $context
     *
     * @return ConfigurationStruct
     */
    public function getSettings(?string $salesChannelId = null, ?Context $context = null): ConfigurationStruct {
        $structData = [];
        $systemConfigData = $this->systemConfigService->getDomain(self::SYSTEM_CONFIG_DOMAIN, $salesChannelId, true);

        foreach ($systemConfigData as $key => $value) {
            if (stripos($key, self::SYSTEM_CONFIG_DOMAIN) !== false) {
                $structData[substr($key, strlen(self::SYSTEM_CONFIG_DOMAIN))] = $value;
            } else {
                $structData[$key] = $value;
            }
        }

        if (isset($structData['papUrl']) && $structData['papUrl'] != '') {
            // needed format is sub.domain.com/installation_dir/
            $papUrl = str_replace('https://', '', $structData['papUrl']);
            $papUrl = str_replace('http://', '', $papUrl);
            $papUrl = rtrim($papUrl, '/') . '/';
            $structData['papUrl'] = $papUrl;
        }

        if (!isset($structData['accountId']) || (isset($structData['accountId']) && $structData['accountId'] == '')) {
            $structData['accountId'] = 'default1';
        }

        return (new ConfigurationStruct())->assign($structData);
    }
}