<?php declare(strict_types=1);
/*
 * (c) shopware AG <info@shopware.com>
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Qu\Postaffiliatepro\Settings;

use Shopware\Core\Framework\Struct\Struct;

class ConfigurationStruct extends Struct {

    /**
     * @var string
     */
    protected $papUrl;

    /**
     * @var string
     */
    protected $username;

    /**
     * @var string
     */
    protected $password;

    /**
     * @var string
     */
    protected $accountId;

    /**
     * @var bool
     */
    protected $trackCoupon = true;

    /**
     * @var string
     */
    protected $trackingStyle = 'order';


    public function getPapUrl(): string {
        if (empty($this->papUrl)) {
            return '';
        }
        return $this->papUrl;
    }

    public function setPapUrl(string $url): void {
        $this->papUrl = $url;
    }

    public function getUsername(): string {
        if (empty($this->username)) {
            return '';
        }
        return $this->username;
    }

    public function setUsername(string $username): void {
        $this->username = $username;
    }

    public function getPassword(): string {
        if (empty($this->password)) {
            return '';
        }
        return $this->password;
    }

    public function setPassword(string $password): void {
        $this->password = $password;
    }

    public function getAccountId(): string {
        return $this->accountId;
    }

    public function setAccountId(string $id): void {
        $this->accountId = $id;
    }

    public function getTrackCoupon(): bool {
        return $this->trackCoupon;
    }

    public function setTrackCoupon(bool $coupon): void {
        $this->trackCoupon = $coupon;
    }

    public function getTrackingStyle(): string {
        return $this->trackingStyle;
    }

    public function setTrackingStyle(string $style): void {
        $this->trackingStyle = $style;
    }
}
